/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.ras;

import ibm.nways.jdm.JdmServer;
import ibm.nways.ras.Traces;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Event;
import java.awt.Frame;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Vector;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCListEvent;
import jclass.bwt.JCListListener;
import jclass.bwt.JCMultiColumnList;

public class TraceGuiFrame
extends Frame
implements ActionListener,
WindowListener,
JCListListener {
    private Button flushButton;
    private Button saveButton;
    private Button quitButton;
    private PopupMenu popup;
    private JCMultiColumnList list;
    private MenuItem miToggle;
    private Vector selectionVector;
    private static String ON_STRING = "On";
    private static String OFF_STRING = "Off";
    private boolean standAlone = false;
    private JdmServer jdmServer;

    public static void main(String[] stringArray) {
        TraceGuiFrame traceGuiFrame = new TraceGuiFrame(true);
        traceGuiFrame.show();
    }

    private long getTraceFlag() {
        long l = 0L;
        if (this.standAlone) {
            try {
                if (this.jdmServer != null) {
                    l = this.jdmServer.getTraceMask();
                }
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        } else {
            l = Traces.traceMask;
        }
        System.out.println("returning traceFlag value of " + l);
        return l;
    }

    private void setTraceFlag(long l) {
        block4: {
            System.out.println("setting traceFlag to " + l);
            if (this.standAlone) {
                try {
                    if (this.jdmServer != null) {
                        this.jdmServer.setTraceMask(l);
                        return;
                    }
                    break block4;
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                    return;
                }
            }
            Traces.traceMask = l;
        }
    }

    public TraceGuiFrame(boolean bl) {
        super("Trace Utility");
        this.standAlone = bl;
        this.initialize();
    }

    public TraceGuiFrame() {
        super("Trace Utility");
        this.initialize();
    }

    private void initialize() {
        String[] stringArray;
        if (this.standAlone) {
            try {
                stringArray = "rmi://" + InetAddress.getLocalHost().getHostName() + ":" + 2099 + "/" + "JdmServer";
                System.out.println("lookup string is " + (String)stringArray);
                this.jdmServer = (JdmServer)Naming.lookup((String)stringArray);
                Traces.initializeTraces(InetAddress.getLocalHost().getHostName(), 2099);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            catch (UnknownHostException unknownHostException) {
                unknownHostException.printStackTrace();
            }
            catch (NotBoundException notBoundException) {
                notBoundException.printStackTrace();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }
        this.setLayout(new BorderLayout());
        this.list = new JCMultiColumnList(10, false);
        stringArray = new String[]{"Category", "On/Off"};
        this.list.setColumnLabels(stringArray);
        this.add("Center", this.list);
        long l = this.getTraceFlag();
        Vector<String> vector = null;
        long l2 = 1L;
        int n = 0;
        while (n < 34) {
            vector = new Vector<String>();
            vector.addElement(Traces.TRACE_STRINGS[n]);
            if ((l & l2) != 0L) {
                vector.addElement(ON_STRING);
            } else {
                vector.addElement(OFF_STRING);
            }
            this.list.addItem(vector);
            l2 <<= 1;
            ++n;
        }
        this.list.addItemListener(this);
        Panel panel = new Panel();
        this.saveButton = new Button("Save");
        this.flushButton = new Button("Flush");
        this.quitButton = new Button("Quit");
        panel.add(this.saveButton);
        panel.add(this.flushButton);
        panel.add(this.quitButton);
        this.add("South", panel);
        this.saveButton.addActionListener(this);
        this.quitButton.addActionListener(this);
        this.flushButton.addActionListener(this);
        this.popup = new PopupMenu();
        this.miToggle = new MenuItem("Toggle trace state");
        this.miToggle.addActionListener(this);
        MenuItem menuItem = new MenuItem("Cancel");
        this.popup.add(this.miToggle);
        this.popup.add(menuItem);
        this.add(this.popup);
        this.pack();
    }

    public void listItemSelectEnd(JCListEvent jCListEvent) {
        Event event = jCListEvent.getSourceEvent();
        if (jCListEvent.getSource() == this.list && event.id == 502) {
            System.out.println("Mouse event received");
            this.selectionVector = (Vector)this.list.getSelectedItem();
            if (this.selectionVector != null) {
                this.popup.show(this.list, event.x, event.y + 10);
            }
        }
    }

    private void saveChanges() {
        Vector vector = null;
        long l = 1L;
        long l2 = 0L;
        int n = 0;
        while (n < 34) {
            vector = (Vector)this.list.getItem(n);
            if (ON_STRING.equals(vector.elementAt(1))) {
                l2 |= l;
            }
            l <<= 1;
            ++n;
        }
        this.setTraceFlag(l2);
    }

    public void listItemSelectBegin(JCListEvent jCListEvent) {
    }

    public void itemStateChanged(JCItemEvent jCItemEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.quitButton) {
            this.saveChanges();
            this.dispose();
            if (this.standAlone) {
                System.exit(0);
                return;
            }
        } else {
            if (actionEvent.getSource() == this.saveButton) {
                this.saveChanges();
                return;
            }
            if (actionEvent.getSource() == this.flushButton) {
                Traces.flush();
                return;
            }
            if (actionEvent.getSource() == this.miToggle && this.selectionVector != null) {
                String string = (String)this.selectionVector.elementAt(1);
                if (ON_STRING.equals(string)) {
                    this.selectionVector.setElementAt(OFF_STRING, 1);
                } else {
                    this.selectionVector.setElementAt(ON_STRING, 1);
                }
                this.list.replaceItem(this.selectionVector, this.list.getSelectedIndex());
            }
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.saveChanges();
        this.dispose();
        if (this.standAlone) {
            System.exit(0);
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

